using System;

class Program
{
    static int BinarnaPretraga(int X, int[] glasovi, int levi, int desni, ref bool prisutan)
    {
        if (desni >= levi)
        {
            int srednji = levi + (desni - levi) / 2;
            if (glasovi[srednji] > X)
            {
                return BinarnaPretraga(X, glasovi, levi, srednji - 1, ref prisutan);
            }
            else if (glasovi[srednji] < X)
            {
                return BinarnaPretraga(X, glasovi, srednji + 1, desni, ref prisutan);
            }
            else
            {
                prisutan = false;
                return srednji;
            }
        }
        return levi;
    }

    static int BrojGlasova(int X, int N, int[] glasovi)
    {
        bool prisutan = true;
        int vrednost = BinarnaPretraga(X, glasovi, 0, N - 1, ref prisutan);
        if (vrednost == (N + Convert.ToInt32(prisutan)) / 2)
        {
            return prisutan ? 0 : 1;
        }
        return (vrednost * 2 > (N + Convert.ToInt32(prisutan)) ? 1 : -1) * (2 *
            vrednost - N - Convert.ToInt32(X > glasovi[N - 1])) + (prisutan ? 0 : 1);
    }
    static void Main()
    {
        string[] brojevi = Console.ReadLine().Split(' ');
        int N = int.Parse(brojevi[0]);
        int Q = int.Parse(brojevi[1]);

        int[] glasovi = new int[N];
        string[] a = Console.ReadLine().Split(' ');
        for (int i = 0; i < N; i++)
            glasovi[i] = int.Parse(a[i]);

        Array.Sort(glasovi);

        string[] b = Console.ReadLine().Split(' ');
        for (int i = 0; i < Q; i++)
        {
            int X = int.Parse(b[i]);
            Console.WriteLine(BrojGlasova(X, N, glasovi));
        }

        Console.ReadLine();
    }
}